
#libraries
library(nlme)
library(Rmisc)
library(emmeans)
library(dplyr)
library(ggplot2)
library(tidyr)

#Vcmax--------------------------------------------------------------------------
  #subset data set into only burned trees
Burn<-subset(Vcmax.df, Burn.status=="Burned")
#Is Vcmax related to the degree of tree damage?
  #Month treated as random effect, Tree ID nested inside of month
model.vcmax<-lme(Vcmax~Tree.damage,
            random=~1|Month/Tree.ID,
            data=Burn)
Anova(model.vcmax, type=3) 
summary(model4)
#yes, positive correlation between Vcmax and tree damage
#p = 0.04665

#Is Vcmax related to leaf water potential? 
  #(only for subset on which we measured vcmax)
model.wp<-lme(Water.potential~Vcmax,
              random=~1|Month/Tree.ID,
              data=Burn.wp)
Anova(model.wp, type=3)
summary(model.wp)
#yes, as Vcmax increases, leaf water potential decreases
#p=0.004
r.squaredGLMM(model.wp)
#R2=0.43

#Leaf water potential------------------------------------------------------------
  #summarize by Tree ID to produce average and standard error for each tree
water.potential.summary<-summarySE(water.potential.data, measurevar="water potential", groupvars=c("Tree.ID", "Tree.damage"), na.rm=TRUE)
#Does leaf water potential differ between burned and unburned trees?
  #using burn status (burned or unburned) as categorical variable
Water.potential.box<-lme(water.potential~Burn.status+Month,
                         random=~1|Tree.ID,
                         data=water.potential.summary)
Anova(Water.potential.box, type=3)
summary(Water.potential.box)
#yes, leaf water potential is higher in burned than in unburned trees
#burn status p = 0.015**
#leaf water potential is lower in August than in June
#month p < 0.0001**
  #included interaction but was non-significant
  #month:burn p = 0.35

#Photosynthesis------------------------------------------------------------------
  #summarize by Tree ID to produce average and standard error for each tree
water.potential.summary<-summarySE(water.potential.data, measurevar="water potential", groupvars=c("Tree.ID", "Tree.damage"), na.rm=TRUE)
#Does maximum leaf photosynthesis differ between burned and unburned trees?
Amax.box<-lme(Photo~Burn.status*Month,
              random=~1|Tree.ID,
              data=All.Survey.Amax)
Anova(Amax.box, type=3)
summary(Amax.box)
#no, leaf water potential is similar between burned and unburned trees?
#burn status p = 0.12
#leaf water potential differs among months
#month p = 0.0006
#leaf water potential differs among months differently in burned trees than in unburned trees
#burn.status*month p = 0.009
emmeans(Amax.box, pairwise~Month|Burn.status)

#Soil water content---------------------------------------------------------------
  #summarize by day of year
swc.summary<-summarySE(swc, measurevar="VWC", 
                       groupvars=c("DOY", "soil.burn.sev"), na.rm=TRUE)
#Does soil water content (VWC) vary among areas of soil damage (Low, Moderate, High)?
swc.model<-lm(VWC~soil.burn.sev+DOY,
              data=swc.summary)
Anova(swc.model)
#yes, soil water content differs among areas of soil damage
#p < 0.001**
#interaction between soil burn severity and DOY not significant
#p = 0.69
summary(swc.model)
#pairwise comparison to determine differences among areas of soil damage
emmeans(swc.model, pairwise~soil.burn.sev)
#soil water content is highest in the most severely damaged soil areas

# Tree damage metric ------------------------------------------------------------
  #To calculate tree metric
  #Two missing red needle heights (Pipo 491, 492), calculated using relationship between tree damage and bole char metric (tree damage = (bolechar_ht - 3)/11.47.
  #Controls assigned as 0 (Pipo 432, 498, 437).
#Burn metric across range of tree height
metolius.tree <- dat %>% 
  filter(ID != 1003) %>%
  group_by(Site, Species, ID) %>% 
  summarise(RootDensity_mgRoot_cm3Soil = sum(RootDensity_mgRoot_cm3Soil),
            DBH_cm = mean(dbh_cm),
            BurnIndex = mean(BurnIndex),
            Height_m = mean(ht_m),
            BoleChar = mean(bole.char.ht_m))  
  #BurnIndex = Tree damage
summary(lm(BurnIndex ~ Height_m, metolius.tree))
summary(lm(BoleChar ~ BurnIndex, data = metolius.tree))

# Root density ------------------------------------------------------------
#Tidy data: need to sum roots of the three size classes----
metolius2 <- dat %>% 
  filter(ID != 1003) %>%
  group_by(Site, Species, ID, Dripline, BurnSide) %>% 
  summarise(RootDensity_mgRoot_cm3Soil = sum(RootDensity_mgRoot_cm3Soil),
            DBH_cm = mean(dbh_cm),
            BurnIndex = mean(BurnIndex),
            Height_m = mean(ht_m),
            BoleChar = mean(bole.char.ht_m))

#BurnIndex = Tree damage

#Does total root density decline with increasing tree damage?----
summary(mod <- lme(RootDensity_mgRoot_cm3Soil ~ BurnIndex, random = ~1|ID/BurnSide/Dripline, data = metolius2)) #Yes, R2 = 0.11, p < 0.01

##Does the decline in total root density with increasing tree damage depend upon the burn side?----
summary(aov(RootDensity_mgRoot_cm3Soil ~ BurnIndex*BurnSide, data = metolius2)) #No
##Does the decline in total root density with increasing tree damage depend upon the dripline location?----
summary(aov(RootDensity_mgRoot_cm3Soil ~ BurnIndex*Dripline, data = metolius2)) #Yes, F = 4.58, p = 0.036.
##Does the decline in root density with increasing tree damage depend upon the root size class?----
summary(aov(RootDensity_mgRoot_cm3Soil ~ BurnIndex*RootSize_mm, data = dat)) #No


#Is total root density different between dripline locations?----
summary(aov(RootDensity_mgRoot_cm3Soil ~ Dripline, data = metolius2)) #No
#Is total root density different between burnside locations?----
summary(aov(RootDensity_mgRoot_cm3Soil ~ BurnSide, data = metolius2)) #Yes, F = 8.06, p < 0.001
##Does the effect of burnside location on root density depend on the dripline?----
summary(aov(RootDensity_mgRoot_cm3Soil ~ BurnSide*Dripline, data = metolius2)) #No
##Does the effect of burnside location on root density depend on the BurnIndex?----
summary(aov(RootDensity_mgRoot_cm3Soil ~ BurnSide*BurnIndex, data = metolius2)) #No

#Leaf nitrogen-------------------------------------------------------------
#Is leaf nitrogen correlated with photosynthetic capacity (VCmax)?
model.N<-lme(percentN~Tree.damage,
             random=~1|Month,
             data=NeedleN)
Anova(model.N, type=3)
#yes, VCmax is positvely related to needle nitrogen values
#p = 0.034
summary(model.N)
r.squaredGLMM(model.N)
#R2 = 0.06