#Revised Correlations between Moving Window Size and Overall Accuracy 
  #created 2020-03-23  
  #updated by Andrew W. Child 2022-03-21 using raw data from confusion matrices

### Import data for GAP Analyses ### 
GAP<-read.csv("4sites_GAP_es_accuracybyradius.csv", header = TRUE)
GAP_bb <- subset(GAP, StudyArea=="browns_bench") 
GAP_craters <- subset(GAP, StudyArea=="craters")
GAP_rr <- subset(GAP, StudyArea=="raft_river")
GAP_wy <- subset(GAP, StudyArea=="wyoming")

#### inspect data ###
GAP

### Test for Normality within GAP data ###  
shapiro.test(GAP_bb$Radius)
  #Normally distributed (p > 0.5), so correlation test selection will be determined off of distribution of accuracy rather than radius
  #Applies to all of the data sets, as the radius categories are the same.

shapiro.test(GAP_bb$Accuracy_Per)
  #Accuracy is normally distributed, Pearson correlation

shapiro.test(GAP_craters$Accuracy_Per)
  #Accuracy is not normal, Spearman rank correlation instead of Pearson

shapiro.test(GAP_rr$Accuracy_Per)
  #Accuracy is normally distributed, Pearson correlation

shapiro.test(GAP_wy$Accuracy_Per)
  #Accuracy is not normal, Spearman rank correlation instead of Pearson

### Test for Correlation between Radius and Accuracy within GAP data ###
cor.test(~Radius + GAP_bb$Accuracy_Per, data = GAP_bb, conf.level = 0.95)
  #correlation is significant p = 0.0001849, r = -0.9998151, t = -73.539
  
cor.test(~Radius + GAP_craters$Accuracy_Per, data = GAP_craters, conf.level = 0.95, method = c("spearman"))
  #correlation is NOT significant p = 0.2254, rho = -0.7745967, S = 17.746

cor.test(~Radius + GAP_rr$Accuracy_Per, data = GAP_rr, conf.level = 0.95)
  #correlation is NOT significant p = 0.1269, r = -0.8730958, t = -2.5326 
 
cor.test(~Radius + GAP_wy$Accuracy_Per, data = GAP_wy, conf.level = 0.95, method = c("spearman"))
  #correlation is NOT significant p = 0.05132, rho = 0.9486833, S = 0.51317

### Import Data for LANDFIRE at the community-level Analyses ###
LFcommunity <- read.csv("4sites_Lfcommunity_accuracybyra.csv")
LFcommunity_bb <- subset(LFcommunity, StudyArea=="browns_bench")
LFcommunity_craters <- subset(LFcommunity, StudyArea=="craters")
LFcommunity_rr <- subset(LFcommunity, StudyArea=="raft_river")
LFcommunity_wy <- subset(LFcommunity, StudyArea=="wyoming")

### inspect data ###
LFcommunity

### Test for Normality within LANDFIRE Community-level data ###  
shapiro.test(LFcommunity_bb$Radius)
  #Normally distributed (p > 0.5), so correlation test selection will be determined off of distribution of accuracy rather than radius
  #Applies to all of the data sets, as the radius categories are the same.

shapiro.test(LFcommunity_bb$Accuracy_Per)
  #Accuracy is not normal, Spearman rank correlation instead of Pearson

shapiro.test(LFcommunity_craters$Accuracy_Per)
  #Accuracy is normally distributed, Pearson correlation

shapiro.test(LFcommunity_rr$Accuracy_Per)
  #Accuracy is normally distributed, Pearson correlation

shapiro.test(LFcommunity_wy$Accuracy_Per)
  #Accuracy is normally distributed, Pearson correlation

### Test for Correlation between Radius and Accuracy within LANDFIRE community-level data ###
cor.test(~LFcommunity_bb$Radius + LFcommunity_bb$Accuracy_Per, data = LFcommunity_bb, conf.level = 0.95, method = c("spearman"))
  #correlation is NOT significant p = 0.7418, rho = -0.2581989, S = 12.582

cor.test(~Radius + LFcommunity_craters$Accuracy_Per, data = LFcommunity_craters, conf.level = 0.95)
  #correlation is NOT significant p = 0.07124, r = 0.9287612, t = 3.5434

cor.test(~Radius + LFcommunity_rr$Accuracy_Per, data = LFcommunity_rr, conf.level = 0.95)
  #correlation is significant p = 0.02479, r = -0.9752119, t = -6.2328

cor.test(~Radius + LFcommunity_wy$Accuracy_Per, data = LFcommunity_wy, conf.level = 0.95)
  #correlation is significant p = 0.03653, r = 0.9634691, t = 5.0876

### Import Data for LANDFIRE at the species-level Analyses ###
LFspecies <-read.csv("4sites_LFspecies_accuracybyradi.csv")
LFspecies_bb <- subset(LFspecies, StudyArea=="browns_bench")
LFspecies_craters <- subset(LFspecies, StudyArea=="craters")
LFspecies_rr <- subset(LFspecies, StudyArea=="raft_river")
LFspecies_wy <- subset(LFspecies, StudyArea=="wyoming") 

### inspect data ###
LFspecies

### Test for Normality within LANDFIRE species-level data ###  
shapiro.test(LFspecies_bb$Radius)
  #Normally distributed (p > 0.5), so correlation test selection will be determined off of distribution of accuracy rather than radius
  #Applies to all of the data sets, as the radius categories are the same.

shapiro.test(LFspecies_bb$Accuracy_Per)
  #Accuracy is normally distributed, Pearson correlation

shapiro.test(LFspecies_craters$Accuracy_Per)
  #Accuracy is not normal, Spearman rank correlation instead of Pearson

shapiro.test(LFspecies_rr$Accuracy_Per)
  #Accuracy is normally distributed, Pearson correlation

shapiro.test(LFspecies_wy$Accuracy_Per)
  #Accuracy is normally distributed, Pearson correlation

### Test for Correlation between Radius and Accuracy within LANDFIRE species-level data ###
cor.test(~Radius + LFspecies_bb$Accuracy_Per, data = LFspecies_bb, conf.level = 0.95)
  #correlation is NOT significant p = 0.4726, r = 0.5274168, t = 0.87791

cor.test(~Radius + LFspecies_craters$Accuracy_Per, data = LFspecies_craters, conf.level = 0.95, method = c("spearman"))
  #correlation is NOT significant p = 0.5528, rho = -0.4472136, S = 14.472

cor.test(~Radius + LFspecies_rr$Accuracy_Per, data = LFspecies_rr, conf.level = 0.95)
  #correlation is significant p = 0.0283, r = -0.9716995, t = -5.8174

cor.test(~Radius + LFspecies_wy$Accuracy_Per, data = LFspecies_wy, conf.level = 0.95)
  #correlation is significant p = 0.02856, r = 0.9714355, t = 5.7893